
function closeTable(id) {
    swal({
        title: "Masayı Kapatmak İstediğine Emin Misin?",
        text: "Seçtiğiniz masa kapanacaktır.",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
        .then((willDelete) => {
            if (willDelete) {
                // Ajax Form ekleyeceksin bro buraya yapıalcak işlemi get/post etcek
                swal("Masa başarıyla kapatıldı.", {
                    icon: "success",
                }); 
            } else {
                //  swal("");
                //
            }
        });
}
function removeOrder(id) {
    swal({
        title: "Siparişi Silmek İstediğine Emin Misin?",
        text: "Seçtiğiniz masa kapanacaktır.",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
        .then((willDelete) => {
            if (willDelete) {
                // Ajax Form ekleyeceksin bro buraya yapıalcak işlemi get/post etcek
                swal("Sipariş başarıyla silindi.", {
                    icon: "success",
                });
            } else {
                //  swal("");
                //
            }
        });
}

function complete_order(id) {
    swal({
        title: "Sipariş Vermek İstediğine Emin Misin?",
        text: "Seçtiğiniz ürünler masaya işlenecektir.",
        icon: "success",
        buttons: true,
        dangerMode: false,
    }).then((willDelete) => {
            if (willDelete) {
                // Ajax Form ekleyeceksin bro buraya yapıalcak işlemi get/post etcek
                swal("Masaya sipariş başarıyla verildi.", {
                    icon: "success",
                });
                window.location.href = 'index.php';

            } else {
                //  swal("");
                //
            }
        });
}


function openTable(id) {
    swal({
        title: "Masayı Açmak İstediğine Emin Misin?",
        text: "Seçtiğiniz masa açılacaktır.",
        icon: "success",
        buttons: true,
        dangerMode: false,
    })
        .then((willDelete) => {
            if (willDelete) {
                // Ajax Form ekleyeceksin bro buraya yapıalcak işlemi get/post etcek
                swal("Masa başarıyla kapatıldı.", {
                    icon: "success",
                });
            } else {
                //  swal("");
                //
            }
        });
}


function editOrder(id){
    var url = "action/edit_order.php";
    $.ajax({
        type: "POST",
        url: url,
        // data: form.serialize(), // serializes the form's elements.
        data: "id="+id,
        success: function(data)
        {
            if($("#adisyon_model")){
                $("#adisyon_model").remove();
                $("body").append(data);
                $("#adisyon_model").modal();
            }
            else{
                $("body").append(data);
                $("#adisyon_model").modal();
            }

        }
    });

}



function table_adisyon(id){
    var url = "action/adisyon.php";
    $.ajax({
        type: "POST",
        url: url,
        // data: form.serialize(), // serializes the form's elements.
        data: "id="+id,
        success: function(data)
        {
            if($("#adisyon_model")){
                $("#adisyon_model").remove();
                $("body").append(data);
                $("#adisyon_model").modal();
            }
            else{
                $("body").append(data);
                $("#adisyon_model").modal();
            }

        }
    });

}
var cart = [];

function currencyFormat(num) {

    return '₺' + parseFloat(num).toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
}
function currencyFormatInt(num) {

    return parseInt(parseFloat(num).toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,'));
}
function formatNumber(num) {
    return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
}
$(function () {
    if (localStorage.cart)
    {
        // local storage üzerinden verileri alalım.
        cart = JSON.parse(localStorage.cart);
        console.log(localStorage.cart);
        showCart();  // display cart that is loaded into cart array
    }
});
function saveCart() {
    if (window.localStorage)
    {
        localStorage.cart = JSON.stringify(cart);

    }
}
function showCart() {
    var totalPrice = 0;
    $("#order1 ul").empty();
    for (var i in cart) {
        var item = cart[i];
        $(".product_items .item").each(function(){
            if($(this).attr("data-id") == item.ID ){
                $(this).addClass("active");
                $(this).attr("data-qty", item.Qty );
            }
        });
        var price_show = currencyFormat(item.Price);
        var price_show2 = currencyFormatInt(item.Price);
        var row = '<li><div class="row"><div class="col-4"><h2>' + item.Product + '</h2></div><div class="col-2 text-center"><h3>' + price_show + '</h3></div><div class="col-3 text-center"  data-qty="' + item.Qty + '" data-price="'  + item.Price + '" data-title="' + item.Product + '" data-id="' + item.ID + '"><h3 class="cartButtons d-flex align-items-center"> <i class="zmdi zmdi-minus minus_cart" onclick="minus_cart($(this))"></i><strong>' + item.Qty + '</strong><i class="zmdi zmdi-plus plus_cart" onclick="plus_cart($(this))"></i></h3> </div><div class="col-3 text-right "><h4> <ion-icon onclick="deleteItem(' + item.ID + ')" class="zmdi zmdi-close-circle delete_cart" ></ion-icon></h4></div></div></li>';
        $("#order1 ul").append(row);
         totalPrice += price_show2;
    }
    $("#subtotal_Price").html(currencyFormat(totalPrice));
    $("#total_Price").html(currencyFormat(totalPrice));


}

function addToCart(price,name,productid,qty) {
    var qty = qty;
    for (var i in cart) {
        if(cart[i].ID == productid)
        {
            cart[i].Qty = qty;
            cart[i].Price = qty * cart[i].DefaultPrice ;
            showCart();
            saveCart();
            return;
        }
    }
    var item = { Product: name,  DefaultPrice: price, Price: price, Qty: qty, ID: productid };
    cart.push(item);
    saveCart();
    showCart();
}


function deleteItem(index){
    for (var i in cart) {
        var item = cart[i];

        if(index == item.ID ) {
            cart.splice(i,1);
        }
    }
    $(".item[data-id="+ index + "]").removeClass("active");
    showCart();
    saveCart();
}

function minusToCart(price,name,productid,qty) {
    var qty = qty;
    for (var i in cart) {
        if(cart[i].ID == productid)
        {
            cart[i].Qty = qty;
            cart[i].Price = qty * cart[i].DefaultPrice ;

            if(qty == 0){
                deleteItem(productid);
            }
            showCart();
            saveCart();
            return;
        }
    }
    var item = { Product: name,  Price: price, Qty: qty, ID: productid };
    cart.push(item);
    saveCart();
    showCart();
}
$("#cart_empty").click(function(){
    cart = [];
    saveCart();
    showCart();
    $(".product_items .item").removeClass("active");
});
function minus_cart(e) {
    var product_id = $(e).parent().parent().attr("data-id");
    var product_title = $(e).parent().parent().attr("data-title");
    var product_price = $(e).parent().parent().attr("data-price");
    var product_qty = parseInt($(e).parent().parent().attr("data-qty"));
    var product_qty_new2 = product_qty - 1;
    if(product_qty_new2 < 0) {
        return false;
    }
    if(product_qty == 1) {
        $(e).parent().parent().removeClass("active");
    }

    if(product_qty_new2 == 0){
        $(e).fadeOut();
        var product_qty_new = 0;
    }
    else{
        var product_qty_new = product_qty_new2;
    }

    $(e).parent().parent().attr("data-qty",product_qty_new);

    minusToCart(product_price,product_title,product_id,product_qty_new);
}



function plus_cart(e){
    $(e).parent().find(".minus_cart").fadeIn();
    var product_id = $(e).parent().parent().attr("data-id");
    var product_title = $(e).parent().parent().attr("data-title");
    var product_price = $(e).parent().parent().attr("data-price");
    var product_qty = parseInt($(e).parent().parent().attr("data-qty"));
    var product_qty_new = product_qty + 1;
    $(e).parent().parent().attr("data-qty",product_qty_new);
    $(e).parent().parent().addClass("active");
    addToCart(product_price,product_title,product_id,product_qty_new);
}

$(".product_items .item .minus_cart").click(function(){
    var e = $(this);
    minus_cart(e);
});


$(".product_items .item .plus_cart").click(function(){
    var e = $(this);
    plus_cart(e);
});
